#include <REGX52.H>
#include <intrins.h>

#define W_CMD 0x02
#define R_CMD 0x01
#define ERASE 0x03

sfr ISP_DATA = 0xE2;
sfr ISP_ADDRH = 0xE3;
sfr ISP_ADDRL = 0xE4;
sfr ISP_CMD = 0xE5;
sfr ISP_TRIG = 0xE6;
sfr ISP_CONTR = 0xE7;

void ISP_IAP_Enable()
{
	EA = 0;
	ISP_CONTR = ISP_CONTR & 0x18;
	ISP_CONTR = ISP_CONTR | 0x01;
	ISP_CONTR = ISP_CONTR | 0x80;
}

void ISP_IAP_Disable()
{
	ISP_CONTR = ISP_CONTR & 0x7F;
	ISP_CMD = 0x00;
	ISP_TRIG = 0x00;
	EA = 1;
}

void ISPTrig()
{
	ISP_TRIG = 0x46;
	ISP_TRIG = 0xb9;
	_nop_();
}

unsigned char read(unsigned short addr)
{
	unsigned char ret = 0;
	EA = 0;
	ISP_ADDRL = (unsigned char)(addr & 0x00FF);
	ISP_ADDRH = (unsigned char)(addr >> 8);
	ISP_IAP_Enable();
	ISP_CMD = ISP_CMD & 0xF8;
	ISP_CMD = ISP_CMD | R_CMD;
	ISPTrig();
	ret = ISP_DATA;
	ISP_IAP_Disable();
	EA = 1;
	return ret;
}

void write(unsigned short addr, unsigned char d)
{
	EA = 0;
	ISP_ADDRL = (unsigned char)(addr & 0x00FF);
	ISP_ADDRH = (unsigned char)(addr >> 8);
	ISP_IAP_Enable();
	ISP_CMD = ISP_CMD & 0xF8;
	ISP_CMD = ISP_CMD | W_CMD;
	ISP_DATA = d;
	ISPTrig();
	ISP_IAP_Disable();
	EA = 1;
}

void erase(unsigned short addr)
{
	EA = 0;
	ISP_ADDRL = (unsigned char)(addr & 0x00FF);
	ISP_ADDRH = (unsigned char)(addr >> 8);
	ISP_IAP_Enable();
	ISP_CMD = ISP_CMD & 0xF8;
	ISP_CMD = ISP_CMD | ERASE;
	ISPTrig();
	ISP_IAP_Disable();
	EA = 1;
}

unsigned long readLong()
{
	unsigned long ret = 0x00000000;
	ret = read(0x2000);
	ret = ret << 8;
	ret += read(0x2001);
	ret = ret << 8;
	ret += read(0x2002);
	ret = ret << 8;
	ret += read(0x2003);
	return ret;
}

void writeLong(unsigned long num)
{
	erase(0x2000);
	write(0x2003,(unsigned char)(num & 0x000000FF));
	num = num >> 8;
	write(0x2002,(unsigned char)(num & 0x000000FF));
	num = num >> 8;
	write(0x2001,(unsigned char)(num & 0x000000FF));
	num = num >> 8;
	write(0x2000,(unsigned char)(num & 0x000000FF));
}